﻿using System;
using System.Configuration;
using System.IO;
using System.Net;
using System.Reflection;
using System.Threading;
using System.Threading.Tasks;
using ClientDemo.Utils;
using gov.va.med.VBECS.Communication.Channels;
using gov.va.med.VBECS.Communication.Clients;
using gov.va.med.VBECS.Communication.Common;
using gov.va.med.vbecs.Common.Log;
using gov.va.med.VBECS.Communication.Utils;

namespace ClientDemo.Demos
{
    public class SequentialMessager : IClientDemo
    {
        ILogger _logger = LogManager.Instance().LoggerLocator.GetLogger(MethodBase.GetCurrentMethod().DeclaringType);
        ManualResetEvent _cancel = new ManualResetEvent(false);

        public void Dispose()
        {
            throw new NotImplementedException();
        }

        public void Start()
        {
            var serverIp = ConfigurationManager.AppSettings.Get("ServerIP");
            var serverPort = ConfigurationManager.AppSettings.Get("ServerPort");
            var msgTimeout = int.Parse(ConfigurationManager.AppSettings.Get("MsgTimeout"));

            Console.WriteLine("Press enter to connect to the server: " + serverIp + ":" + serverPort);
            Console.ReadLine(); //Wait user to press enter

            
            using (var client = ClientFactory.CreateClient<MockPinger>(new IPEndPoint(IPAddress.Parse(serverIp), int.Parse(serverPort))))
            {
                client.Connect();
                using (var sequentialMessager = new SequentialMessager<IClient, MockPinger>(client) { Timeout = 1000 * 60 })
                {
                    sequentialMessager.Start();
                    client.MessageReceived -= client_message_received;
                    client.MessageReceived += client_message_received;
                    //read a test message
                    var messages = new FileMessageFactory().ReadMesages("InputMessage");
                    if (messages == null)
                    {
                        _logger.Info("No messages were found. Exit.");
                        return;
                    }

                    Console.WriteLine("\n\rPress Escape to disconnect from server or C to send again");
                    Task.Run(() =>
                    {
                        while (true)
                        {
                            Thread.Sleep(100);
                            if (Console.ReadKey(true).Key != ConsoleKey.Escape) continue;
                            _cancel.Set();
                            return;
                        }
                    });

                    var key = ConsoleKey.B;

                    while (true)
                    {
                        //if (key == ConsoleKey.C)
                        //    do_start(sequentialMessager);
                        if (key == ConsoleKey.B)
                        {
                            foreach (var message in messages)
                            {
                                IMessage responce = null;
                                try
                                {
                                    responce = sequentialMessager.SendReceive(message, 10000);
                                }
                                catch (Exception e)
                                {
                                    Console.WriteLine("Error message (blocking): " + e.Message);
                                }
                                if (responce != null)
                                    Console.WriteLine("Response to blocking message [{1}]: {0}", new TextMessage(responce.GetBytes()).Text, responce.RepliedId);
                                if (_cancel.WaitOne(msgTimeout))
                                {
                                    return;
                                }

                            }
                            
                        }

                        /*while (true)
                        {
                            Thread.Sleep(100);
                            key = Console.ReadKey(true).Key;
                            if (key == ConsoleKey.C || key == ConsoleKey.B) break;
                            if (key == ConsoleKey.Escape) break;
                        }*/
                    }
                }
            }
        }

        static void client_message_received(object sender, MessageEventArgs e)
        {
            var message = e.Message as TextMessage; //Server only accepts text messages
            if (message == null && e.Message is RawDataMessage)
            {
                // Try to construct message from RawMessage
                message = new TextMessage(((RawDataMessage)e.Message).Data);
            }
            if (message == null) return;

            Console.WriteLine("Response from messager [{0}]: " + message.Text, e.Message.RepliedId);
        }


        /*
        protected virtual void do_start_blocking(IMessager client)
        {
            string filename = null;
            try
            {
                filename = ConfigurationManager.AppSettings.Get("InputMessage");
            }
            // ReSharper disable EmptyGeneralCatchClause
            catch { }
            // ReSharper restore EmptyGeneralCatchClause

            for (var i = 0; i < 10; i++)
            {
                IMessage aMessage;
                if (filename == null)
                {
                    Console.Write("Write some message to be sent to server: ");
                    aMessage = new TextMessage(Console.ReadLine()); //Get a message from user
                }
                else
                {
                    if (!File.Exists(filename + _counter + ".txt"))
                    {
                        Console.Write("file doesn't exists: " + filename + _counter + ".txt");
                        Console.Write("Exist");
                        return;
                    }

                    Console.Write("Deserialize message from the file: " + filename + _counter + ".txt");
                    IMessageSerializer sr = new TextMessageSerializer();
                    aMessage = sr.DeSerializeObject(filename + _counter++ + ".txt");
                }

                IMessage message = null;
                try
                {
                    Console.WriteLine("Start sending blocking message [{1}]: {0}", aMessage.Text, aMessage.Id);
                    message = ((SequentialMessager<IClient, MockPinger>) client).SendReceive(aMessage, 10000);
                }
                catch (Exception e)
                {
                    Console.WriteLine("Error message (blocking): " + e.Message);
                }
                if (message != null)
                    Console.WriteLine("Response to blocking message [{1}]: {0}",
                        new TextMessage(message.GetBytes()).Text, message.RepliedId);
            }

        }

        protected virtual void do_start(IMessager client)
        {
            string filename = null;
            try
            {
                filename = ConfigurationManager.AppSettings.Get("InputMessage");
            }
            // ReSharper disable EmptyGeneralCatchClause
            catch { }
            // ReSharper restore EmptyGeneralCatchClause

            for(var i = 0; i < 10; i++)
            {
                IMessage aMessage;
                if (filename == null)
                {
                    Console.Write("Write some message to be sent to server: ");
                    aMessage = new TextMessage(Console.ReadLine()); //Get a message from user
                }
                else
                {
                    if (!File.Exists(filename + _counter + ".txt"))
                    {
                        Console.Write("file doesn't exists: " + filename + _counter + ".txt");
                        Console.Write("Exist");
                        return;
                    }

                    Console.Write("Deserialize message from the file: " + filename + _counter + ".txt");
                    IMessageSerializer sr = new TextMessageSerializer();
                    aMessage = sr.DeSerializeObject(filename + _counter++ + ".txt");
                }

                ((SequentialMessager<IClient, MockPinger>)client).Send(aMessage, 10000,
                                                            delegate(IMessage message)
                                                                {
                                                                    try
                                                                    {
                                                                        Console.WriteLine(
                                                                            "Response to message [{1}]: {0}",
                                                                            new TextMessage(message.GetBytes()).Text,
                                                                            message.RepliedId);
                                                                    }
                                                                    catch (Exception e)
                                                                    {
                                                                        Console.WriteLine("Error message: " + e.Message);
                                                                    }
                                                                });
                Console.WriteLine("A message sent [{1}]: {0}", new TextMessage(((RawDataMessage)aMessage).Data).Text, aMessage.Id);
            }
        }
        */

    }
}
